<?php
/**
 * Script para extrair o conteúdo da função upgram_product_widget_shortcode()
 * e mover para templates/woocommerce/product-content.php
 * 
 * VERSÃO ADMIN - Execute via WordPress Admin
 * 
 * Adicione este código temporariamente em admin/settings-page.php ou execute via linha de comando
 */

// Verificar se estamos no WordPress (já deve estar carregado quando chamado via admin)
if (!defined('ABSPATH')) {
    die("Erro: Este script deve ser executado via WordPress Admin.\n");
}

// Verificar se UPGRAM_PATH está definido
if (!defined('UPGRAM_PATH')) {
    die("Erro: Plugin Upgram não está ativo ou UPGRAM_PATH não está definido.\n");
}

// Definir caminhos usando constantes do plugin
$shortcodes_file = UPGRAM_PATH . 'public/shortcodes.php';
$output_file = UPGRAM_PATH . 'templates/woocommerce/product-content.php';

if (!file_exists($shortcodes_file)) {
    die("Erro: Arquivo shortcodes.php não encontrado em: $shortcodes_file\n");
}

if (!file_exists(dirname($output_file))) {
    // Criar diretório se não existir
    wp_mkdir_p(dirname($output_file));
}

echo "=== SCRIPT DE EXTRAÇÃO DE CONTEÚDO ===\n\n";
echo "Lendo arquivo shortcodes.php...\n";
$content = file_get_contents($shortcodes_file);
$lines = explode("\n", $content);

// Encontrar início do conteúdo HTML (após ob_start e variáveis)
// O conteúdo HTML começa na linha 363 com ?>
$html_start_line = 362; // Índice 0-based (linha 363)
$html_end_line = 6617; // Linha com ?> antes de ob_get_clean

echo "Conteúdo HTML encontrado nas linhas " . ($html_start_line + 1) . " até " . ($html_end_line + 1) . "\n";

// Extrair código HTML/PHP entre ?> e ?>
$extracted_lines = [];

for ($i = $html_start_line; $i <= $html_end_line; $i++) {
    if (isset($lines[$i])) {
        $line = $lines[$i];
        $extracted_lines[] = $line;
    }
}

// Remover ob_start() e ob_get_clean() se estiverem nas linhas extraídas
$cleaned_lines = [];
foreach ($extracted_lines as $line) {
    $trimmed = trim($line);
    // Pular linhas específicas de buffer
    if (strpos($trimmed, 'ob_start()') !== false) {
        continue;
    }
    if (strpos($trimmed, 'ob_get_clean()') !== false) {
        continue;
    }
    if (strpos($trimmed, 'return $output;') !== false) {
        continue;
    }
    // Manter todas as outras linhas
    $cleaned_lines[] = $line;
}

echo "Extraídas " . count($cleaned_lines) . " linhas de conteúdo (após limpeza)\n";

// Ler o arquivo product-content.php atual
if (!file_exists($output_file)) {
    die("Erro: Arquivo product-content.php não encontrado em: $output_file\n");
}

$template_content = file_get_contents($output_file);

// Encontrar onde inserir o conteúdo (após as variáveis iniciais)
// Procurar pela linha que define $price_table_view
$insert_marker = '$price_table_view = upgram_get_option_cached';
$insert_position = strpos($template_content, $insert_marker);

if ($insert_position === false) {
    // Tentar outro marcador
    $insert_marker = '// Obter tipo de visualização da tabela de preços';
    $insert_position = strpos($template_content, $insert_marker);
}

if ($insert_position === false) {
    die("Erro: Marcador de inserção não encontrado no template. Procurando por: $insert_marker\n");
}

// Encontrar o final da linha do marcador (procurar por ; ou ?>)
$line_end = strpos($template_content, ';', $insert_position);
if ($line_end === false) {
    $line_end = strpos($template_content, "\n", $insert_position);
}
if ($line_end !== false) {
    $insert_position = $line_end + 1;
} else {
    $insert_position = strpos($template_content, "\n", $insert_position) + 1;
}

// Construir novo conteúdo
$new_content = substr($template_content, 0, $insert_position);
$new_content .= "\n";
$new_content .= "// ========================================\n";
$new_content .= "// CONTEÚDO EXTRAÍDO DE shortcodes.php\n";
$new_content .= "// Linhas " . ($html_start_line + 1) . " até " . ($html_end_line + 1) . "\n";
$new_content .= "// Extraído em: " . date('Y-m-d H:i:s') . "\n";
$new_content .= "// ========================================\n";
$new_content .= "\n";
$new_content .= implode("\n", $cleaned_lines);
$new_content .= "\n\n";
$new_content .= "// ========================================\n";
$new_content .= "// FIM DO CONTEÚDO EXTRAÍDO\n";
$new_content .= "// ========================================\n";
$new_content .= "\n";

// Remover a parte antiga que usa a função como fallback
$old_fallback_start = strpos($new_content, '// IMPORTANTE: Este arquivo precisa incluir');
if ($old_fallback_start !== false) {
    // Encontrar o final do bloco de fallback
    $old_fallback_end = strpos($new_content, '} else {', $old_fallback_start);
    if ($old_fallback_end === false) {
        $old_fallback_end = strlen($new_content);
    } else {
        // Encontrar o final do else
        $old_fallback_end = strrpos($new_content, '}', $old_fallback_end);
        if ($old_fallback_end !== false) {
            $old_fallback_end = strpos($new_content, "\n", $old_fallback_end) + 1;
        } else {
            $old_fallback_end = strlen($new_content);
        }
    }
    
    // Substituir por comentário simples
    $new_content = substr($new_content, 0, $old_fallback_start) . 
                  "// ========================================\n" .
                  "// FIM DO CONTEÚDO DA PÁGINA DO PRODUTO\n" .
                  "// ========================================\n" .
                  "\n" .
                  "// NOTA: Todo o conteúdo HTML foi renderizado acima via echo direto\n" .
                  "// O cache é gerenciado no início deste arquivo\n";
}

// Fazer backup do arquivo original
$backup_file = $output_file . '.backup.' . date('Y-m-d_H-i-s');
if (copy($output_file, $backup_file)) {
    echo "Backup criado: $backup_file\n";
}

// Escrever novo arquivo
if (file_put_contents($output_file, $new_content)) {
    echo "\n✓ SUCESSO! Conteúdo extraído e salvo em: $output_file\n";
    echo "Total de linhas extraídas: " . count($cleaned_lines) . "\n";
    echo "\n";
    echo "PRÓXIMOS PASSOS:\n";
    echo "1. Revise o arquivo product-content.php\n";
    echo "2. Teste a página do produto no site\n";
    echo "3. Se tudo funcionar, delete este script\n";
    echo "4. O backup está em: $backup_file\n";
} else {
    die("ERRO: Não foi possível escrever no arquivo $output_file. Verifique permissões.\n");
}

